#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "lista.h"

FILE *safe_fopen(char *naziv, char *rezim, int exit_code){
    FILE *pf = fopen(naziv,rezim);
    if(pf == NULL){
        printf("Neuspesno otvaranje fajla\n");
        exit(exit_code);
    }
    return pf;
}

void ucitaj(FILE *ulazna, CVOR **glava, float uneta_povrsina){
    
    char tmp_kategorija[MAX_KATEGORIJA];
    char tmp_naziv[MAX_NAZIV];
    float tmp_cena;
    CVOR *novi = NULL;
    while(fscanf(ulazna,"%s %s %f",tmp_kategorija,tmp_naziv,&tmp_cena)!=EOF){
        novi = create_node(tmp_kategorija,tmp_naziv,tmp_cena,uneta_povrsina);
        add_sorted(glava,novi);
    }   
}

void ispis(CVOR *glava, FILE *izlazna, CVOR *nadjeni){
    CVOR *tekuci = glava;
    while(tekuci != NULL){
        fprintf(izlazna,"%12s %12s %12.2f$ %12.2f$\n",
                        tekuci->kategorija,tekuci->naziv,
                        tekuci->cena, tekuci->ukupna_cena);
        tekuci = tekuci->sledeci;
    }
    if(nadjeni == NULL){
        fprintf(izlazna,"\n\nMaterijal zadate kategorije nije pronadjen!\n");
    }else{
        fprintf(izlazna,"\n\nMaterijal kategorije %s najblizi zeljenoj vrednosti je %s\n",
            nadjeni->kategorija, nadjeni->naziv);
    }
}

CVOR *pronadji_najblizi(CVOR *glava, char *kategorija, float zeljena_cena){
    CVOR *tekuci = glava;
    CVOR *nadjeni = NULL;
    while(tekuci != NULL){
        if(!strcmp(tekuci->kategorija,kategorija)){
            if(nadjeni == NULL){
                nadjeni = tekuci;
            }else if(fabs(tekuci->ukupna_cena - zeljena_cena)<(nadjeni->ukupna_cena - zeljena_cena)){
                nadjeni= tekuci;
            }

        }
        tekuci = tekuci->sledeci;
    }
    return nadjeni;
}

int main(int argc, char **argv){

    if(argc != 6){
        printf("Primer poziva programa: ./a.out input.txt output.txt 3.5 80 Drvo\n");
        exit(1);
    }
    CVOR *glava;
    init(&glava);
    FILE *ulazna = safe_fopen(argv[1],"r",2);
    FILE *izlazna = safe_fopen(argv[2],"w",2);
    
    ucitaj(ulazna,&glava,atof(argv[3]));
    CVOR *nadjeni = pronadji_najblizi(glava,argv[5],atof(argv[4]));
    ispis(glava,izlazna,nadjeni);

    clear(&glava);
    fclose(ulazna);
    fclose(izlazna);
    return 0;
}