#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#include "lista.h"

FILE *safe_fopen(char *naziv, char *rezim, int kod_greske);
void ucitaj_materijale(FILE *ulazna, CVOR **pglava, float povrsina);
void ispisi_materijale(FILE *izlazna, CVOR *glava);

CVOR *nadji_najblizi_ceni(CVOR *glava, float cena, char *kategorija);

int main(int argc, char **argv)
{
    if(argc != 6)
    {
        printf("Primer poziva programa: %s input.txt output.txt 3.5 80 Drvo\n", argv[0]);
        return 1;
    }

    CVOR *glava;

    init(&glava);

    FILE *ulazna = safe_fopen(argv[1], "r", 2);
    ucitaj_materijale(ulazna, &glava, atof(argv[3]));
    fclose(ulazna);

    FILE *izlazna = safe_fopen(argv[2], "w", 2);
    ispisi_materijale(izlazna, glava);
    CVOR *najblizi_sa_kat = nadji_najblizi_ceni(glava, atof(argv[4]), argv[5]);
    if(najblizi_sa_kat != NULL)
    {
        fprintf(izlazna, "Materijal kategorije %s najblizi zeljenoj vrednosti je %s\n",
            argv[5], najblizi_sa_kat->naziv);
    }
    else
    {
        fprintf(izlazna, "Ne postoji materijal kategorije %s\n", argv[5]);
    }

    fclose(izlazna);

    clear(&glava);

    return 0;
}

FILE *safe_fopen(char *naziv, char *rezim, int kod_greske)
{
    FILE *fp = fopen(naziv, rezim);

    if(fp == NULL)
    {
        printf("Greska prilikom otvaranja %s datoteke!\n", naziv);
        exit(kod_greske);
    }

    return fp;
}

void ucitaj_materijale(FILE *ulazna, CVOR **pglava, float povrsina)
{
    char tmp_kategorija[MAX_KATEGORIJA];
    char tmp_naziv[MAX_NAZIV];
    float tmp_cena;

    while(fscanf(ulazna, "%s %s %f", tmp_kategorija, tmp_naziv, &tmp_cena) != EOF)
    {
        CVOR *novi = create_node(tmp_kategorija, tmp_naziv, tmp_cena, povrsina);
        add_sorted(pglava, novi);
    }
}

void ispisi_materijale(FILE *izlazna, CVOR *glava)
{
    CVOR *tekuci = glava;

    while(tekuci != NULL)
    {
        fprintf(izlazna, "%12s %12s %12.2f$ %12.2f$\n",
            tekuci->kategorija, tekuci->naziv, tekuci->cena, tekuci->ukupna_cena);
        tekuci = tekuci->sledeci;
    }
}

CVOR *nadji_najblizi_ceni(CVOR *glava, float cena, char *kategorija)
{
    CVOR *tekuci = glava, *nadjen = NULL;
    float najbliza_razlika; // posto mora biti u odredjenoj kategoriji, najblizu razliku cemo inicijalizovati tek u petlji cim naidjemo na prvi materijal koji zadovoljava zadati uslov

    while(tekuci != NULL)
    {
        if(strcmp(tekuci->kategorija, kategorija) == 0)
        {
            float tekuca_razlika = fabs(tekuci->ukupna_cena - cena);
            if(nadjen == NULL || tekuca_razlika < najbliza_razlika) // dodato "nadjen == NULL ||" u odnosu na ono sto smo imali na predavanju da bi se dobio tacan rezultat
            {
                najbliza_razlika = tekuca_razlika;
                nadjen = tekuci;
            }
        }
        tekuci = tekuci->sledeci;
    }

    return nadjen;
}
