#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "stablo.h"

FILE *safe_fopen(char *ime, char *rezim, int kod_greske);
void ucitaj_polaske(FILE *ulazna, POLAZAK **pkoren);
void ispisi_red_voznje(FILE *izlazna, POLAZAK *koren);

POLAZAK *najjeftiniji_pre_vremena(POLAZAK *koren, char *odrediste, char *vreme);

void validiraj_vreme(char *vreme);

int main(int argc, char **argv)
{
    if(argc != 5)
    {
        printf("Primer poziva programa: %s polasci.txt red-voznje.txt Zrenjanin 13.00\n", argv[0]);
        return 1;
    }

    validiraj_vreme(argv[4]);

    POLAZAK *koren;

    inicijalizacija(&koren);

    FILE *ulazna = safe_fopen(argv[1], "r", 3);
    ucitaj_polaske(ulazna, &koren);
    fclose(ulazna);

    POLAZAK *najjeftiniji = najjeftiniji_pre_vremena(koren, argv[3], argv[4]);

    if(najjeftiniji != NULL)
    {
        printf("Polazak pre %s casova za mesto %s sa najjeftinijom kartom je: %s %s %s %.2lf\n",
            argv[4], argv[3], najjeftiniji->odrediste, najjeftiniji->vreme_polaska, najjeftiniji->prevoznik, najjeftiniji->cena_karte);
    }
    else
    {
        printf("Ne postoji polazak za mesto %s pre %s casova.\n", argv[3], argv[4]);
    }

    FILE *izlazna = safe_fopen(argv[2], "w", 4);
    ispisi_red_voznje(izlazna, koren);
    fclose(izlazna);

    obrisi_stablo(&koren);

    return 0;
}

FILE *safe_fopen(char *ime, char *rezim, int kod_greske)
{
    FILE *fp = fopen(ime, rezim);

    if(fp == NULL)
    {
        printf("Datoteku sa imenom %s nije moguce otvoriti!\n", ime);
        exit(kod_greske);
    }

    return fp;
}

void ucitaj_polaske(FILE *ulazna, POLAZAK **pkoren)
{
    char tmp_odrediste[MAX_ODREDISTE];
    char tmp_vreme_polaska[MAX_VREME_POLASKA];
    char tmp_prevoznik[MAX_PREVOZNIK];
    double tmp_cena_karte;

    while(fscanf(ulazna, "%s %s %s %lf",
        tmp_odrediste, tmp_vreme_polaska, tmp_prevoznik, &tmp_cena_karte) != EOF)
    {
        POLAZAK *novi = napravi_cvor(tmp_odrediste, tmp_vreme_polaska, tmp_prevoznik, tmp_cena_karte);
        dodaj_u_stablo(pkoren, novi);
    }
}

void ispisi_red_voznje(FILE *izlazna, POLAZAK *koren)
{
    if(koren != NULL)
    {
        ispisi_red_voznje(izlazna, koren->levi);
        fprintf(izlazna, "%9s %5s %-15s %7.2lf\n",
            koren->odrediste, koren->vreme_polaska, koren->prevoznik, koren->cena_karte);
        ispisi_red_voznje(izlazna, koren->desni);
    }
}

POLAZAK *najjeftiniji_pre_vremena(POLAZAK *koren, char *odrediste, char *vreme)
{
    POLAZAK *najjeftiniji = NULL;

    if(koren != NULL)
    {
        if(strcmp(koren->odrediste, odrediste) == 0 && strcmp(koren->vreme_polaska, vreme) <= 0)
        {
            najjeftiniji = koren;
        }

        POLAZAK *levi_najjeftiniji = najjeftiniji_pre_vremena(koren->levi, odrediste, vreme);

        if(najjeftiniji == NULL ||
            (levi_najjeftiniji != NULL && levi_najjeftiniji->cena_karte < najjeftiniji->cena_karte))
        {
            najjeftiniji = levi_najjeftiniji;
        }

        POLAZAK *desni_najjeftiniji = najjeftiniji_pre_vremena(koren->desni, odrediste, vreme);

        if(najjeftiniji == NULL ||
            (desni_najjeftiniji != NULL && desni_najjeftiniji->cena_karte < najjeftiniji->cena_karte))
        {
            najjeftiniji = desni_najjeftiniji;
        }
    }

    return najjeftiniji;
}

void validiraj_vreme(char *vreme)
{
    if(strlen(vreme) != 5 || vreme[2] != '.')
    {
        printf("Nevalidan format vremena, ocekivani format: cc.mm\n");
        exit(2);
    }

    int cas = (vreme[0] - '0') * 10;
    cas += vreme[1] - '0';

    int minut = (vreme[3] - '0') * 10;
    minut += vreme[4] - '0';

    if((cas < 0 || cas > 23) || (minut < 0 || minut > 59))
    {
        printf("Nevalidan format vremena, ocekivani format: cc.mm\n");
        exit(2);
    }
}