#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "stablo.h"

FILE *safe_fopen(char *ime, char *rezim, int kod_greske);
void ucitaj_polaske(FILE *ulazna, POLAZAK **pkoren);
void ispisi_red_voznje(FILE *izlazna, POLAZAK *koren);

POLAZAK *nadji_najjefiniji_do_mesta(POLAZAK *koren, char *mesto, char *vreme);  // pre zadatog vremena, to nije uradjeno bilo na predavanju

void validacija_vremena(char *vreme);   // funkcija validira uneti argument komandne linije da li odgovara formatu cc.mm (c - cas, m - minut)

int main(int argc, char **argv)
{
    if(argc != 5)
    {
        printf("Primer poziva programa: %s polasci.txt red-voznje.txt Zrenjanin 13.00\n", argv[0]);
        return 1;
    }

    validacija_vremena(argv[4]);    // provera vremena pre bilo kojih operacija sa stablom/datotekama

    POLAZAK *koren;

    inicijalizacija(&koren);

    FILE *ulazna = safe_fopen(argv[1], "r", 3);
    ucitaj_polaske(ulazna, &koren);
    fclose(ulazna);

    POLAZAK *najjeftiniji = nadji_najjefiniji_do_mesta(koren, argv[3], argv[4]);    // dodat 4. argument koji sadrzi vreme

    // Dodat je lep ispis na ekran u slucaju da (ne) postoji prevoz sa najjefinitijom kartom pre zadatog vremena (testirati dobro sve slucajeve)
    if(najjeftiniji != NULL)
    {
        printf("Polazak pre %s casova za mesto %s sa najjeftinijom kartom je: %s %s %s %.2lf\n",
            argv[3], argv[4], najjeftiniji->odrediste, najjeftiniji->vreme_polaska, najjeftiniji->prevoznik, najjeftiniji->cena_karte);
    }
    else
    {
        printf("Ne postoji polazak za mesto %s pre %s casova.\n", argv[3], argv[4]);
    }

    FILE *izlazna = safe_fopen(argv[2], "w", 4);
    ispisi_red_voznje(izlazna, koren);
    fclose(izlazna);

    obrisi_stablo(&koren);  // obavezno oslobadjamo memoriju

    return 0;
}

FILE *safe_fopen(char *ime, char *rezim, int kod_greske)
{
    FILE *fp = fopen(ime, rezim);

    if(fp == NULL)
    {
        printf("Datoteku sa imenom %s nije moguce otvoriti!\n", ime);
        exit(kod_greske);
    }

    return fp;
}

void ucitaj_polaske(FILE *ulazna, POLAZAK **pkoren)
{
    char tmp_odrediste[MAX_ODREDISTE];
    char tmp_vreme_polaska[MAX_VREME_POLASKA];
    char tmp_prevoznik[MAX_PREVOZNIK];
    double tmp_cena_karte;

    while(fscanf(ulazna, "%s %s %s %lf",
            tmp_odrediste, tmp_vreme_polaska, tmp_prevoznik, &tmp_cena_karte) != EOF)
    {
        POLAZAK *novi = napravi_cvor(tmp_odrediste, tmp_vreme_polaska, tmp_prevoznik, tmp_cena_karte);
        dodaj_u_stablo(pkoren, novi);
    }
}

void ispisi_red_voznje(FILE *izlazna, POLAZAK *koren)
{
    if(koren != NULL)
    {
        ispisi_red_voznje(izlazna, koren->levi);
        fprintf(izlazna, "%9s %5s %-15s %7.2lf\n",
            koren->odrediste, koren->vreme_polaska, koren->prevoznik, koren->cena_karte);
        ispisi_red_voznje(izlazna, koren->desni);
    }
}

POLAZAK *nadji_najjefiniji_do_mesta(POLAZAK *koren, char *mesto, char *vreme)
{
    POLAZAK *najjeftiniji = NULL;

    if(koren != NULL)
    {
        // dovoljno je dodati ovde uslov za vreme, jer ce samo cvorovi koji ispunjavaju oba uslova (odrediste i vreme) biti izabrani, inace NULL
        if(strcmp(koren->odrediste, mesto) == 0 && strcmp(koren->vreme_polaska, vreme) <= 0)
        {
            najjeftiniji = koren;
        }

        POLAZAK *najjeftiniji_levi = nadji_najjefiniji_do_mesta(koren->levi, mesto, vreme);     // ne zaboraviti vreme i u rekurzivnim pozivima

        if(najjeftiniji == NULL || 
            (najjeftiniji_levi != NULL && najjeftiniji_levi->cena_karte < najjeftiniji->cena_karte))
        {
            najjeftiniji = najjeftiniji_levi;
        }

        POLAZAK *najjeftiniji_desni = nadji_najjefiniji_do_mesta(koren->desni, mesto, vreme);   // ne zaboraviti vreme i u rekurzivnim pozivima

        if(najjeftiniji == NULL ||
            (najjeftiniji_desni != NULL && najjeftiniji_desni->cena_karte < najjeftiniji->cena_karte))
        {
            najjeftiniji = najjeftiniji_desni;
        }
    }

    return najjeftiniji;
}

// Implementacija validacije, provera velicine i pozicije gde treba da bude tacka
// Izvlacenje casa i minuta i provera da li se nalazi u zadatim granicama
// Ako ne ispunjava neki od navedenih uslova, izlazi se iz programa sa kodom 2
void validacija_vremena(char *vreme)
{
    if(strlen(vreme) != 5 || vreme[2] != '.')
    {
        printf("Vreme se unosi u formatu cc.mm, na primer 12.34!\n");
        exit(2);
    }

    int cas = (vreme[0] - '0') * 10 + (vreme[1] - '0');
    int minut = (vreme[3] - '0') * 10 + (vreme[4] - '0');

    if((cas < 0 || cas > 23) || (minut < 0 || minut > 59))
    {
        printf("Vreme se unosi u formatu cc.mm, na primer 12.34!\n");
        exit(2);
    }
}
